#include <algorithm>
#include <cstdint>
#include <iostream>
#include <vector>

using namespace std;

uint32_t solve(const vector<uint32_t> &arr);

uint32_t solve(const vector<uint32_t> &arr) {
  uint32_t sequences = 0;

  for (size_t i = 1; i < arr.size(); ++i)
    if (arr[i] < arr[i - 1])
      ++sequences;

  return sequences;
}

int main() noexcept {
  std::ios::sync_with_stdio(false);
  std::cin.tie(nullptr);
  std::cout.tie(nullptr);
  std::cerr.tie(nullptr);

  vector<uint32_t> karte;
  uint32_t n, q;
  uint32_t i, j;

  cin >> n >> q;
  karte = vector<uint32_t>(n);
  for (i = 0; i < n; ++i)
    cin >> karte[i];

  cout << solve(karte) << '\n';
  for (j = 0; j < q; ++j) {
    uint32_t qi, qj;
    cin >> qi >> qj;
    swap(karte[qi - 1], karte[qj - 1]);
    cout << solve(karte) << '\n';
  }
}